#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTest.VAL;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;

using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{
	[TestFixture]
	public class BOL_Orders  : BaseTest 
	{
		BOL.Orders _orders;

		[SetUp]
		protected void SetUp() 
		{
			this.BaseSetUp();
			VistALinkUnitTestHarness.RequireConnection();

			if (this.RefreshData)
			{
				DataCreator.CreateNewOrder(true);
				this.RefreshData = false;
			}
		}

		[TearDown]
		protected void TearDown()
		{
			VistALinkUnitTestHarness.ReleaseConnection(); 
		}


		#region inner classes

		[Test]
		public void SelectOrderEventArgs_Pass()
		{
			Common.AcceptOrderStatus type = Common.AcceptOrderStatus.ReadyForAcceptance;
			// 
			BOL.Orders.SelectOrderEventArgs args = new BOL.Orders.SelectOrderEventArgs( type );
			//
			Assert.IsNotNull( args );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void SelectOrderEventArgs_Fail()
		{
		}

		[Test]
		public void AcceptOrderStatus_Pass()
		{
			Common.AcceptOrderStatus type = Common.AcceptOrderStatus.ReadyForAcceptance;
			// 
			BOL.Orders.SelectOrderEventArgs args = new BOL.Orders.SelectOrderEventArgs( type );
			//
			Assert.IsTrue( args.AcceptOrderStatus.Equals( type ) );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void AcceptOrderStatus_Fail()
		{
		}

		#endregion


		#region constructor

		[Test]
		public void Ctor_Pass()
		{
			BOL.Orders orders = new BOL.Orders();
			Assert.IsNotNull(orders);
			Assert.AreEqual(true, orders.DisplayOrders != null && orders.DisplayOrders.Count > 0, "DisplayOrders");
			Assert.AreEqual(true, orders.AllComponentOrders != null && orders.AllComponentOrders.Rows.Count > 0, "AllComponentOrders");
			Assert.AreEqual(true, orders.AllTestOrders != null && orders.AllTestOrders.Rows.Count > 0, "AllTestOrders");
		}
		[Test]
		public void Ctor_Fail()
		{
			Common.LogonUser.LogonUserDivisionCode = "FOO";
			BOL.Orders orders = new BOL.Orders();
			Assert.AreEqual(true, orders.DisplayOrders != null && orders.DisplayOrders.Count == 0,"DisplayOrders");
			Assert.AreEqual(true, orders.AllComponentOrders != null && orders.AllComponentOrders.Rows.Count == 0,"AllComponentOrders");
			Assert.AreEqual(true, orders.AllTestOrders != null && orders.AllTestOrders.Rows.Count == 0,"AllTestOrders");
		}

		#endregion


		#region properties

		[Test]
		public void SelectedOrder_Pass()
		{
			_orders = new BOL.Orders();

			bool otCheck = false;
			bool ocCheck = false;

			foreach(DataRow drCheck in _orders.DisplayOrders)
			{//FOR
				
				if (!drCheck.IsNull(TABLES.OrderedComponent.LabTestId) && !drCheck.IsNull(TABLES.OrderedComponent.LabOrderNumber))
				{
					if (!(drCheck[TABLES.OrderedComponent.LabTestId].ToString() == "") && !(drCheck[TABLES.OrderedComponent.LabOrderNumber].ToString() == ""))
					{
						//We want to check one O   n  one OC
						if (drCheck.Table.Columns.Contains(TABLES.ComponentClass.ComponentClassName))
						{
							try
							{
								_orders.SelectedOrder = new BOL.OrderedComponent(drCheck);
								ocCheck = true;
							}
							catch(Exception e)
							{
								Assert.IsTrue(false, "1-" + e.Message);
							}
					
						}
						else
						{
							try
							{
								_orders.SelectedOrder = new BOL.OrderedTest(drCheck);
								otCheck = true;
							}
							catch(Exception e)
							{
								Assert.IsTrue(false, "2-" + e.Message);
							}
						}
					}
				}
                if (otCheck && ocCheck) break;
			}//FOR
			Assert.AreEqual(true, _orders.SelectedOrder != null, "Final");
			Assert.AreEqual(true, otCheck && ocCheck, "OC+OT were checked");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void SelectedOrder_Fail()
		{
		}


		[Test]
		public void DisplayOrders_Pass()
		{
			_orders = new BOL.Orders();
			Assert.IsTrue(_orders.DisplayOrders != null && _orders.DisplayOrders.Count > 0);
		}
		[Test]
		public void DisplayOrders_Fail()
		{
			Common.LogonUser.LogonUserDivisionCode = "FOO";
			_orders = new BOL.Orders();
			Assert.IsTrue(_orders.DisplayOrders != null && _orders.DisplayOrders.Count == 0);
		}


		[Test]
		public void AllComponentOrders_Pass()
		{
			_orders = new BOL.Orders();
			Assert.IsTrue(_orders.AllComponentOrders != null && _orders.AllComponentOrders.Rows.Count > 0);
		}
		[Test]
		public void AllComponentOrders_Fail()
		{
			Common.LogonUser.LogonUserDivisionCode = "FOO";
			_orders = new BOL.Orders();
			Assert.IsTrue(_orders.AllComponentOrders != null && _orders.AllComponentOrders.Rows.Count == 0);
		}


		[Test]
		public void AllTestOrders_Pass()
		{
			_orders = new BOL.Orders();
			Assert.IsTrue(_orders.AllTestOrders != null && _orders.AllTestOrders.Rows.Count > 0);
		}
		[Test]
		public void AllTestOrders_Fail()
		{
			Common.LogonUser.LogonUserDivisionCode = "FOO";
			_orders = new BOL.Orders();
			Assert.IsTrue(_orders.AllTestOrders != null && _orders.AllTestOrders.Rows.Count == 0);
		}

		#endregion


		#region methods

		[Test]
		public void FilterOrdersForDisplay_Pass()
		{
			_orders = new BOL.Orders();
			string foundOrderNumber = "";

			foreach (DataRow dr in _orders.DisplayOrders)
			{
				if (!dr.IsNull(TABLES.OrderedTest.LabOrderNumber) && dr[TABLES.OrderedTest.LabOrderNumber].ToString() != "")
				{
					foundOrderNumber = dr[TABLES.OrderedTest.LabOrderNumber].ToString();
					break;
				}
			}
			_orders.FilterOrdersForDisplay(string.Empty, false, DateTime.MinValue, DateTime.MinValue, string.Empty, foundOrderNumber);
			Assert.IsTrue(_orders.DisplayOrders.Count > 0);
		}

		[Test]
		public void FilterOrdersForDisplay_Fail()
		{
			_orders = new BOL.Orders();
			_orders.FilterOrdersForDisplay(string.Empty, false, DateTime.MinValue, DateTime.MinValue, "adfafdsasffdsfds", string.Empty);
			Assert.IsTrue(_orders.DisplayOrders.Count == 0);
		}

		[Test]
		public void Remove_Pass()
		{
			_orders = new BOL.Orders();
			int countBefore = _orders.DisplayOrders.Count;
			DataRow dtRow = (DataRow) _orders.DisplayOrders[0];
			string cprsOrderNumber = (string) dtRow[TABLES.OrderedComponent.CprsOrderNumber];

			_orders.Remove(cprsOrderNumber, false);
			Assert.AreEqual(countBefore, _orders.DisplayOrders.Count , "Before");

			_orders.Remove(cprsOrderNumber, true);
			Assert.AreEqual(countBefore-1, _orders.DisplayOrders.Count , "After");
		}
		[Test]
		[ExpectedException(typeof(ArgumentException))]
		public void Remove_Fail()
		{
			_orders = new BOL.Orders();
			_orders.Remove(null, false);
		}

		[Test]
		public void ProcessComponentSpecimen_Pass()
		{
			DataTable dtComponentOrders = BOL.OrderedComponent.GetComponentOrders();
			DataRow [] dtComponentOrdersArray = dtComponentOrders.Select("OrderStatusCode = 'P' AND SpecimenRequiredIndicator = 1");

			_orders = new BOL.Orders();
			_orders.SelectedOrder = new BOL.OrderedComponent(dtComponentOrdersArray[0]);
			BOL.Specimen specimen = new BOL.Specimen();
			( (BOL.OrderedComponent) _orders.SelectedOrder).AssociateWithSpecimen(specimen);
	
			specimen.IsNew = false;
			specimen.Patient.VistaPatientId = _orders.SelectedOrder.Patient.VistaPatientId;
			specimen.MaintainableSpecimenIndicator = true;
			specimen.SpecimenUid = "1234567890";
			Common.AcceptOrderStatus aOS = _orders.ProcessComponentSpecimen();
			Assert.IsTrue(aOS == Common.AcceptOrderStatus.ReadyForAcceptance);
		}
		[Test]
		public void ProcessComponentSpecimen_Fail()
		{
			DataTable dtComponentOrders = BOL.OrderedComponent.GetComponentOrders();
			DataRow [] dtComponentOrdersArray = dtComponentOrders.Select("OrderStatusCode = 'P' AND SpecimenRequiredIndicator = 1");

			_orders = new BOL.Orders();
			_orders.SelectedOrder = new BOL.OrderedComponent(dtComponentOrdersArray[0]);
			BOL.Specimen specimen = new BOL.Specimen();
			( (BOL.OrderedComponent) _orders.SelectedOrder).AssociateWithSpecimen(specimen);

			// New specimen
			Common.AcceptOrderStatus aOS = _orders.ProcessComponentSpecimen();
			Assert.AreEqual(aOS, Common.AcceptOrderStatus.SpecimenNotInVBECS , "New Specimen");

			// Wrong specimen
			specimen.IsNew = false;
			aOS = _orders.ProcessComponentSpecimen();
			Assert.AreEqual(aOS, Common.AcceptOrderStatus.WrongSpecimen , "Wrong Specimen");

			// Not maintainable
			specimen.Patient.VistaPatientId = _orders.SelectedOrder.Patient.VistaPatientId;
			aOS = _orders.ProcessComponentSpecimen();
			Assert.AreEqual(aOS, Common.AcceptOrderStatus.SpecimenNotMaintainable , "Not Maintainable");

			// Broken rules
			specimen.MaintainableSpecimenIndicator = true;
			aOS = _orders.ProcessComponentSpecimen();
			Assert.AreEqual(aOS, Common.AcceptOrderStatus.SpecimenHasBrokenRules , "Broken Rules");
		}


		[Test]
		[Ignore(StandardIgnoreReasons.Untestable)]
		public void ProcessTestSpecimen_Pass()
		{
			// This is dependent on data from CPRS, so cannot be accurately tested here. -C. Jensen, 20050830
		}
		[Test]
		public void ProcessTestSpecimen_Fail()
		{
			// This method is mostly untestable too, but I've done what I can. -C. Jensen, 20050830
			DataTable dtTestOrders = BOL.OrderedTest.GetTestOrders();
			DataRow [] dtTestOrdersArray = dtTestOrders.Select("OrderStatusCode = 'P'");

			_orders = new BOL.Orders();
			_orders.SelectedOrder = new BOL.OrderedTest(dtTestOrdersArray[0]);
			BOL.Specimen specimen = new BOL.Specimen();
			( (BOL.OrderedTest) _orders.SelectedOrder).Specimen = specimen;
			Common.AcceptOrderStatus aOS = _orders.ProcessTestSpecimen(string.Empty, string.Empty);
			Assert.IsTrue(aOS == Common.AcceptOrderStatus.NoLabDataForSpecimen);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.Untestable)]
		public void PrintReport_Pass()
		{
			// This is dependent on data from CPRS, so cannot be accurately tested here. -C. Jensen, 20050830
		}
		
		[Test]
		[Ignore(StandardIgnoreReasons.Untestable)]
		public void PrintReport_Fail()
		{
			// This is dependent on data from CPRS, so cannot be accurately tested here. -C. Jensen, 20050830
		}


		#endregion
	}
}

#endif
